import { Zap, Mail, Phone, MapPin, Clock, Linkedin, Twitter, Instagram } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-creative">
      <div className="container">
        <div className="footer-content-creative">
          <div className="footer-section-creative">
            <div className="footer-logo-creative">
              <div className="footer-logo-icon-wrapper-creative">
                <Zap className="footer-logo-icon-creative" size={28} />
              </div>
              <h2 className="footer-logo-text-creative">MARKETZAP</h2>
            </div>
            <p className="footer-description-creative">
              Креативные курсы по маркетингу от практикующих экспертов. 
              Современные методики и реальные кейсы для вашего роста.
            </p>
            <div className="footer-social-creative">
              <a href="#" className="social-link-creative">
                <Linkedin size={20} />
              </a>
              <a href="#" className="social-link-creative">
                <Twitter size={20} />
              </a>
              <a href="#" className="social-link-creative">
                <Instagram size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-creative">
            <h3 className="footer-title-creative">Навигация</h3>
            <ul className="footer-links-creative">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-creative">
            <h3 className="footer-title-creative">Контакты</h3>
            <ul className="footer-links-creative">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@marketzap.ru">info@marketzap.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Маркетинговая, 10</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Пт: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-creative">
          <p>&copy; 2025 MARKETZAP. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

